MODULE ay_mat_vec_mod
USE ay_matrix 
IMPLICIT NONE
CONTAINS

FUNCTION ay_mat_vec(trans,u,i_mat_comm,a_mat_comm)
  IMPLICIT NONE
  LOGICAL,     INTENT(IN) :: trans
  COMPLEX(wp), INTENT(IN) :: u(:)
  INTEGER, INTENT(IN), OPTIONAL :: i_mat_comm(:)
  COMPLEX(wp), INTENT(IN), OPTIONAL :: a_mat_comm(:)
  COMPLEX(wp) :: ay_mat_vec(SIZE(u))
  
  !LOCAL VARIABLE
  INTEGER :: bs !Block Size

  
! IF( trans_loc .EQV. .TRUE.) THEN
!     write(*,*) 'TRANSPOSE MUST EQUAL FALSE, we are solving Ax=b NOT A^Tx=b: The ERROR is REPORTED by FUNCTION ay_mat_vec'
!     STOP
!  END IF

  bs = SIZE(data_UL1x1x,1)

  !Setting ay_mat_vec to zero
!  ay_mat_vec(:) = (0.0_wp,0.0_wp) !deleted on 04/07/05 because it redundant, i.e., you don't need it 

  ! Matrix "Block" Row time unknown vector

  !UPPER HALF OF THE MATRIX
  !1st "Block" Row
  ay_mat_vec(1:bs) = MATMUL(data_UL1x1x,u(1:bs)) + MATMUL(data_UL1x2x,u(3*bs+1:4*bs)) + &
                     MATMUL(data_UR1x1x,u(6*bs+1:7*bs)) + MATMUL(data_UR1x2x,u(9*bs+1:10*bs))
  !2nd "Block" Row
  ay_mat_vec(bs+1:2*bs) = MATMUL(data_UL1x1x,u(bs+1:2*bs)) + MATMUL(data_UL1x2x,u(4*bs+1:5*bs)) + &
                          MATMUL(data_UR1x1x,u(7*bs+1:8*bs)) + MATMUL(data_UR1x2x,u(10*bs+1:11*bs))
  !3rd "Block" Row
  ay_mat_vec(2*bs+1:3*bs) = MATMUL(data_UL1x1x,u(2*bs+1:3*bs)) + MATMUL(data_UL1x2x,u(5*bs+1:6*bs)) + &
                            MATMUL(data_UR1x1x,u(8*bs+1:9*bs)) + MATMUL(data_UR1x2x,u(11*bs+1:12*bs)) 
  !4th "Block" Row
  ay_mat_vec(3*bs+1:4*bs) = MATMUL(data_UL2x1x,u(1:bs)) + MATMUL(data_UL2x2x,u(3*bs+1:4*bs)) + &
                            MATMUL(data_UR2x1x,u(6*bs+1:7*bs)) + MATMUL(data_UR2x2x,u(9*bs+1:10*bs))
  !5th "Block" Row
  ay_mat_vec(4*bs+1:5*bs) = MATMUL(data_UL2x1x,u(bs+1:2*bs)) + MATMUL(data_UL2x2x,u(4*bs+1:5*bs)) + &
                            MATMUL(data_UR2x1x,u(7*bs+1:8*bs)) + MATMUL(data_UR2x2x,u(10*bs+1:11*bs))
  !6th "Block" Row
  ay_mat_vec(5*bs+1:6*bs) = MATMUL(data_UL2x1x,u(2*bs+1:3*bs)) + MATMUL(data_UL2x2x,u(5*bs+1:6*bs)) + &
                            MATMUL(data_UR2x1x,u(8*bs+1:9*bs)) + MATMUL(data_UR2x2x,u(11*bs+1:12*bs))

  !LOWER HALF OF THE MATRIX
  !7th "Block" Row
  ay_mat_vec(6*bs+1:7*bs) = MATMUL(data_LL1x1x,u(1:bs)) + MATMUL(data_LL1x1y,u(bs+1:2*bs)) + & 
                            MATMUL(data_LL1x1z,u(2*bs+1:3*bs)) + MATMUL(data_LL1x2x,u(3*bs+1:4*bs)) + &
                            MATMUL(data_LL1x2y,u(4*bs+1:5*bs)) + MATMUL(data_LL1x2z,u(5*bs+1:6*bs)) + &
                            MATMUL(data_LR1x1x,u(6*bs+1:7*bs)) + MATMUL(data_LR1x2x,u(9*bs+1:10*bs))
  !8th "Block" Row
  ay_mat_vec(7*bs+1:8*bs) = MATMUL(data_LL1y1x,u(1:bs)) + MATMUL(data_LL1y1y,u(bs+1:2*bs)) + & 
                            MATMUL(data_LL1y1z,u(2*bs+1:3*bs)) + MATMUL(data_LL1y2x,u(3*bs+1:4*bs)) + &
                            MATMUL(data_LL1y2y,u(4*bs+1:5*bs)) + MATMUL(data_LL1y2z,u(5*bs+1:6*bs)) + &
                            MATMUL(data_LR1x1x,u(7*bs+1:8*bs)) + MATMUL(data_LR1x2x,u(10*bs+1:11*bs))
  !9th "Block" Row
  ay_mat_vec(8*bs+1:9*bs) = MATMUL(data_LL1z1x,u(1:bs)) + MATMUL(data_LL1z1y,u(bs+1:2*bs)) + & 
                            MATMUL(data_LL1z1z,u(2*bs+1:3*bs)) + MATMUL(data_LL1z2x,u(3*bs+1:4*bs)) + &
                            MATMUL(data_LL1z2y,u(4*bs+1:5*bs)) + MATMUL(data_LL1z2z,u(5*bs+1:6*bs)) + &
                            MATMUL(data_LR1x1x,u(8*bs+1:9*bs)) + MATMUL(data_LR1x2x,u(11*bs+1:12*bs))
  !10th "Block" Row
  ay_mat_vec(9*bs+1:10*bs) = MATMUL(data_LL2x1x,u(1:bs)) + MATMUL(data_LL2x1y,u(bs+1:2*bs)) + & 
                             MATMUL(data_LL2x1z,u(2*bs+1:3*bs)) + MATMUL(data_LL2x2x,u(3*bs+1:4*bs)) + &
                             MATMUL(data_LL2x2y,u(4*bs+1:5*bs)) + MATMUL(data_LL2x2z,u(5*bs+1:6*bs)) + &
                             MATMUL(data_LR2x1x,u(6*bs+1:7*bs)) + MATMUL(data_LR2x2x,u(9*bs+1:10*bs))
  !11th "Block" Row
  ay_mat_vec(10*bs+1:11*bs) = MATMUL(data_LL2y1x,u(1:bs)) + MATMUL(data_LL2y1y,u(bs+1:2*bs)) + & 
                              MATMUL(data_LL2y1z,u(2*bs+1:3*bs)) + MATMUL(data_LL2y2x,u(3*bs+1:4*bs)) + &
                              MATMUL(data_LL2y2y,u(4*bs+1:5*bs)) + MATMUL(data_LL2y2z,u(5*bs+1:6*bs)) + &
                              MATMUL(data_LR2x1x,u(7*bs+1:8*bs)) + MATMUL(data_LR2x2x,u(10*bs+1:11*bs))
  !12th "Block" Row
  ay_mat_vec(11*bs+1:12*bs) = MATMUL(data_LL2z1x,u(1:bs)) + MATMUL(data_LL2z1y,u(bs+1:2*bs)) + & 
                              MATMUL(data_LL2z1z,u(2*bs+1:3*bs)) + MATMUL(data_LL2z2x,u(3*bs+1:4*bs)) + &
                              MATMUL(data_LL2z2y,u(4*bs+1:5*bs)) + MATMUL(data_LL2z2z,u(5*bs+1:6*bs)) + &
                              MATMUL(data_LR2x1x,u(8*bs+1:9*bs)) + MATMUL(data_LR2x2x,u(11*bs+1:12*bs))

!TESTING


END FUNCTION ay_mat_vec

END MODULE ay_mat_vec_mod
