!-----------------------------------------------------------------------------------------------------------------------------------------
! TITLE: test.f95
! AUTHOR: Alex Yuffa
! DATE WRITTEN: 10/26/04
! LAST REVISION: 07/11/05
! DESCRIPTION:  Driver for integral equations
!-----------------------------------------------------------------------------------------------------------------------------------------
!  write(*,*) 'sample/Surf = ',num_sample_pts
!  write(*,*) 'ay_R =',ay_R
!  write(*,*) 'spw = ', ay_spw
!  write(*,*) 'rel_acc = ', rel_acc
!  write(*,*) 'max_fun_eval = ', max_fun_eval
!  write(*,*) 'from Sing. = ', from_sing
PROGRAM test
USE ay_matrix
USE ay_constants, ONLY : ay_spw_write, ay_R_write, ay_mu_write, ay_epsilon_write
USE ay_mat_vec_mod, ONLY : ay_mat_vec
USE nag_sparse_lin_sys, ONLY : nag_sparse_gen_lin_sol
USE ay_mat_eval, ONLY : ay_mat_eval_fill

IMPLICIT NONE

COMPLEX(wp), ALLOCATABLE :: true_field(:)
COMPLEX(wp), ALLOCATABLE :: my_result(:)
COMPLEX(wp), ALLOCATABLE :: b(:)
INTEGER :: i, bs, file_1, file_2, pts
LOGICAL :: trans
REAL(wp) :: obs_pt(3)
COMPLEX(wp) :: field_value(3)
!new
INTEGER :: n, m !m added FOR A TEST
REAL(wp) :: R_far, h, rho, theta, z, RCS, theta_scat
REAL(wp) :: tmp_re, tmp_im
REAL(wp) :: time_1, time_2, time
character(40,1) intensity_name
trans = .FALSE.
write(*,*) 'Welcome to JDAY'

write(*,*) 'Type filename for Scattered Field, e.g., name.dat'
read(*,*) intensity_name

file_1=21
file_2=22
open(file_1, file=trim(intensity_name))
open(file_2, file='theta.dat')

write(*,*) 'ay_spw = '
read(*,*) pts
CALL ay_spw_write(pts)

write(*,*) 'mu = '
read(*,*) tmp_re
CALL ay_mu_write(tmp_re)

write(*,*) 'epsilon real part = '
read(*,*) tmp_re
write(*,*) 'epsilon imaginary part = '
read(*,*) tmp_im
CALL ay_epsilon_write(tmp_re,tmp_im)

write(*,*) 'k_o R = '
read(*,*) tmp_re
CALL ay_R_write(tmp_re)


CALL cpu_time(time_1)
write(*,*) 'Starting To Fill The Impedance Matrix(may take a long time)'
CALL ay_matrix_fill()
CALL cpu_time(time_2)
time = (time_2-time_1)/60.0_wp !in minutes
write(*,*) 'Impedance Matrix Fill Time (in m) = ', time

write(*,*) 'The Impedance Matrix Have Been Filled'
write(*,*) 'Starting To Solve For The BD unknowns' 

bs = SIZE(data_UL1x1x,1)
ALLOCATE(true_field(6*bs))
ALLOCATE(my_result(12*bs))
ALLOCATE(b(12*bs))

CALL ay_Einc(true_field)

do i=1, 6*bs
   b(i) = 0.5_wp*true_field(i)
end do

b(6*bs+1:12*bs) = (0.0_wp,0.0_wp)
my_result(1:12*bs) = (0.0_wp,0.0_wp)

CALL cpu_time(time_1)

!Linear Solver: If does not converge play with tol parameter
CALL nag_sparse_gen_lin_sol(ay_mat_vec,b,my_result, method='G',tol=1.0e-7_wp, max_iter=10000 ) 
!tol=1.0e-6_wp 07/10/05 tol=1.0e-5_wp!sometimes fails 1.0e-7_wp 

CALL cpu_time(time_2)
time =(time_2-time_1)/60.0_wp !in minutes
write(*,*) 'Linear Solve Time (in m) = ',time

write(*,*) 'BD unknowns have been found'
write(*,*) 'Staring to compute Far Field'

!Memory Deallocation
DEALLOCATE(true_field)
DEALLOCATE(b)

DEALLOCATE(data_UL1x1x)
DEALLOCATE(data_UL1x2x)
DEALLOCATE(data_UL2x1x)
DEALLOCATE(data_UL2x2x)

DEALLOCATE(data_UR1x1x)
DEALLOCATE(data_UR1x2x)
DEALLOCATE(data_UR2x1x)
DEALLOCATE(data_UR2x2x)

DEALLOCATE(data_LR1x1x)
DEALLOCATE(data_LR1x2x)
DEALLOCATE(data_LR2x1x)
DEALLOCATE(data_LR2x2x)

DEALLOCATE(data_LL1x1x)
DEALLOCATE(data_LL1x1y)
DEALLOCATE(data_LL1x1z)
DEALLOCATE(data_LL1x2x)
DEALLOCATE(data_LL1x2y)
DEALLOCATE(data_LL1x2z)
DEALLOCATE(data_LL1y1x)
DEALLOCATE(data_LL1y1y)
DEALLOCATE(data_LL1y1z)
DEALLOCATE(data_LL1y2x)
DEALLOCATE(data_LL1y2y)
DEALLOCATE(data_LL1y2z)
DEALLOCATE(data_LL1z1x)
DEALLOCATE(data_LL1z1y)
DEALLOCATE(data_LL1z1z)
DEALLOCATE(data_LL1z2x)
DEALLOCATE(data_LL1z2y)
DEALLOCATE(data_LL1z2z)
DEALLOCATE(data_LL2x1x)
DEALLOCATE(data_LL2x1y)
DEALLOCATE(data_LL2x1z)
DEALLOCATE(data_LL2x2x)
DEALLOCATE(data_LL2x2y)
DEALLOCATE(data_LL2x2z)
DEALLOCATE(data_LL2y1x)
DEALLOCATE(data_LL2y1y)
DEALLOCATE(data_LL2y1z)
DEALLOCATE(data_LL2y2x)
DEALLOCATE(data_LL2y2y)
DEALLOCATE(data_LL2y2z)
DEALLOCATE(data_LL2z1x)
DEALLOCATE(data_LL2z1y)
DEALLOCATE(data_LL2z1z)
DEALLOCATE(data_LL2z2x)
DEALLOCATE(data_LL2z2y)
DEALLOCATE(data_LL2z2z)


CALL cpu_time(time_1)

do n=1,500
   R_far = 0.2 + 2.0*ay_pi*n*0.2_wp !2*Pi is incident wavelength
   obs_pt(1) = 0.0_wp
   obs_pt(2) = 0.0_wp
   obs_pt(3) = -R_far

   CALL ay_mat_eval_fill(obs_pt,bs,my_result,field_value)

   RCS = (4.0_wp*ay_pi*R_far**2)*dot_product(field_value,field_value) !conjg is done by dot_product
   theta_scat = R_far - 0.2 !distance away from surface of the scatterer 

   write(file_1,*) RCS 
   write(file_2,*) theta_scat
end do


!--- START OF FAR FIELD AS A FUNCTION OF SCATTERING ANGLE --------------------
!R_far = 100.0_wp !07/10/051.0e4_wp
!theta = 0.0_wp !Scattering Plane = Incidint Plane
!h = 5.0_wp*ay_Pi/180.0 ! 5 degree increments
!n = 36
!m = 18

!do i=0,m
!   rho = R_far*sin(i*h)
!
!   if( (R_far**2 - rho**2)>0 ) then
!      z = Sqrt(R_far**2 - rho**2)
!   else
!      z=0.0_wp
!      rho=R_far-epsilon(R_far)
!   end if
!
!   obs_pt(1)=rho
!   obs_pt(2)=theta
!   obs_pt(3)=z
!
!   CALL ay_mat_eval_fill(obs_pt,bs,my_result,field_value)
!
!   RCS = (4.0_wp*ay_pi*R_far**2)*dot_product(field_value,field_value) !conjg is done by dot_product
!   theta_scat = i*h*180.0_wp/ay_pi !scattering angle in degrees
!
!   write(file_1,*) RCS 
!   write(file_2,*) theta_scat
!end do
!
!
!do i=m+1,n
!   rho = R_far*Sin(i*h)
!
!   if( (R_far**2 - rho**2)>0  ) then
!      z = -Sqrt(R_far**2 - rho**2)
!   else
!      z=0.0_wp
!      rho=R_far-epsilon(R_far)
!   end if
!   
!   obs_pt(1)=rho
!   obs_pt(2)=theta
!   obs_pt(3)=z
!
!   CALL ay_mat_eval_fill(obs_pt,bs,my_result,field_value)
!
!   RCS = (4.0_wp*ay_pi*R_far**2)*dot_product(field_value,field_value) !conjg is done by dot_product
!   theta_scat = i*h*180.0_wp/ay_pi !scattering angle in degrees
!
!   write(file_1,*) RCS 
!   write(file_2,*) theta_scat
!end do
!--- END OF FAR FIELD AS A FUNCTION OF SCATTERING ANGLE ------------------------------------------

!Closing File Streams and Deallocating Memory where BD unknows(now knowns) have been stored
close(file_1)
close(file_2)
DEALLOCATE(my_result)

CALL cpu_time(time_2)
time = (time_2-time_1)/60.0 !in minutes
write(*,*) 'Far Field Calculation Time (in m) = ', time

write(*,*) 'JDAY HAS ENDED'

END PROGRAM test
